<?php
/*======================================================================*\
|| #################################################################### ||
|| # ---------------------------------------------------------------- # ||
|| # Copyright ©2013 Fillip Hannisdal AKA Revan/NeoRevan/Belazor 	  # ||
|| # All Rights Reserved. 											  # ||
|| # This file may not be redistributed in whole or significant part. # ||
|| # ---------------------------------------------------------------- # ||
|| # You are not allowed to use this on your server unless the files  # ||
|| # you downloaded were done so with permission.					  # ||
|| # ---------------------------------------------------------------- # ||
|| #################################################################### ||
\*======================================================================*/

print_cp_header($vbphrase['dbtech_vbsecurity_changelog_list']);

// #############################################################################
if ($_REQUEST['action'] == 'changelog' OR empty($_REQUEST['action']))
{
	// ###################### Start modify #######################
	$users = VBSECURITY::$db->fetchAll('
		SELECT DISTINCT changelog.userid, user.username
		FROM $dbtech_vbsecurity_changelog AS changelog
		LEFT JOIN $user AS user USING(userid)
		ORDER BY username
	');
	$userlist = array('no_value' => $vbphrase['all_log_entries']);
	foreach ($users as $user)
	{
		$userlist[$user['userid']] = ($user['username'] ? $user['username'] : 'user id: ' . $user['userid']);
	}

	$fieldlist = array('no_value' => $vbphrase['all_log_entries']);
	foreach ((array)VBSECURITY::$watchers as $category => $watcherList)
	{
		if (in_array($category, array('general', 'logins')))
		{
			// Skip these
			continue;
		}

		// Set the optgroup
		$fieldlist[$vbphrase['dbtech_vbsecurity_watchers_' . $category]] = array();

		foreach ($watcherList as $name)
		{
			// Set the actual selectable value
			$fieldlist[$vbphrase['dbtech_vbsecurity_watchers_' . $category]][$category . '-=-' . $name] = ($vbphrase['dbtech_vbsecurity_watcher_' . $name] ? $vbphrase['dbtech_vbsecurity_watcher_' . $name] : 'dbtech_vbsecurity_watcher_' . $name);
		}
	}

	// ###################### Start modify #######################
	print_form_header('vbsecurity', 'changelog');
	construct_hidden_code('action', 'view');
	print_table_header($vbphrase['dbtech_vbsecurity_changelog_list']);
	print_input_row($vbphrase['log_entries_to_show_per_page'], 'perpage', 100);
	print_select_row($vbphrase['show_only_entries_generated_by'], '_field', $fieldlist);
	print_select_row($vbphrase['user_name'], 'userid', $userlist);
	print_time_row($vbphrase['start_date'], 'startdate', 0, 0);
	print_time_row($vbphrase['end_date'], 'enddate', 0, 0);
	print_input_row($vbphrase['ip_address'], 'ipaddress');
	print_select_row($vbphrase['order_by'], 'orderby', array(
		'username' 	=> $vbphrase['user_name'],
		'date' 		=> $vbphrase['date'],
	), 'date');
	print_submit_row($vbphrase['view'], 0);

	if (can_access_logs($vbulletin->config['SpecialUsers']['canpruneadminlog'], 1))
	{
		print_form_header('vbsecurity', 'changelog');
		construct_hidden_code('action', 'prune');
		print_table_header($vbphrase['prune_log_entries']);
		print_select_row($vbphrase['dbtech_vbsecurity_remove_entries_user'], 'userid', $userlist, 'no_value');
		print_input_row($vbphrase['dbtech_vbsecurity_remove_entries_days'], 'daysprune', 30);
		print_submit_row($vbphrase['prune_log_entries'], 0);
	}
}

// #############################################################################
if ($_REQUEST['action'] == 'view')
{
	$vbulletin->input->clean_array_gpc('r', array(
		'perpage' 		=> TYPE_UINT,
		'pagenumber' 	=> TYPE_UINT,
		'userid'     	=> TYPE_UINT,
		'orderby' 		=> TYPE_NOHTML,
		'startdate' 	=> TYPE_UNIXTIME,
		'enddate' 		=> TYPE_UNIXTIME,
		'ipaddress'		=> TYPE_STR,
		'_field'		=> TYPE_STR,
	));

	$sqlconds = array();
	$hook_query_fields = $hook_query_joins = '';

	if ($vbulletin->GPC['perpage'] < 1)
	{
		$vbulletin->GPC['perpage'] = 15;
	}

	if ($vbulletin->GPC['startdate'])
	{
		$sqlconds[] = 'changelog.dateline >= ' . $vbulletin->GPC['startdate'];
	}

	if ($vbulletin->GPC['enddate'])
	{
		$sqlconds[] = 'changelog.dateline <= ' . $vbulletin->GPC['enddate'];
	}

	if ($vbulletin->GPC['userid'])
	{
		$sqlconds[] = "changelog.userid = " . $vbulletin->GPC['userid'];
	}

	if ($vbulletin->GPC['ipaddress'])
	{
		$sqlconds[] = 'changelog.ipaddress LIKE \'%' . $vbulletin->GPC['ipaddress'] . '%\'';
	}

	if ($vbulletin->GPC['_field'])
	{
		// Grab what we're searching for
		$fields = explode('-=-', $vbulletin->GPC['_field']);

		// Set the fields
		$sqlconds[] = "changelog.script = " . $db->sql_prepare($fields[0]);
		$sqlconds[] = "changelog.field = " . $db->sql_prepare($fields[1]);
	}

	//($hook = vBulletinHook::fetch_hook('admin_modlogviewer_query')) ? eval($hook) : false;

	$counter = VBSECURITY::$db->fetchOne('
		SELECT COUNT(*) AS total
		FROM $dbtech_vbsecurity_changelog AS changelog
		LEFT JOIN $user AS user USING(userid)
		:hookJoinFields
		:where
	', array(
		':hookJoinFields' 	=> $hook_join_fields,
		':where' 			=> (!empty($sqlconds) ? 'WHERE ' . implode("\r\n\tAND ", $sqlconds) : ''),
	));
	$totalpages = ceil($counter / $vbulletin->GPC['perpage']);

	if ($vbulletin->GPC['pagenumber'] < 1)
	{
		$vbulletin->GPC['pagenumber'] = 1;
	}
	$startat = ($vbulletin->GPC['pagenumber'] - 1) * $vbulletin->GPC['perpage'];

	switch($vbulletin->GPC['orderby'])
	{
		case 'username':
			$order = 'user.username ASC, dateline DESC';
			break;
		case 'date':
		default:
			$order = 'dateline DESC';
	}

	// Query the messages
	$logs = VBSECURITY::$db->fetchAllKeyed('
		SELECT changelog.*, user.username
			:hookQueryFields
		FROM $dbtech_vbsecurity_changelog AS changelog
		LEFT JOIN $user AS user USING(userid)
		:hookJoinFields
		:where
		ORDER BY :order
		LIMIT :limitStart, :limitEnd
	', 'changelogid', array(
		':hookQueryFields' 	=> $hook_query_fields,
		':hookJoinFields' 	=> $hook_join_fields,
		':where' 			=> (!empty($sqlconds) ? 'WHERE ' . implode("\r\n\tAND ", $sqlconds) : ''),
		':order' 			=> $order,
		':limitStart' 		=> $startat,
		':limitEnd' 		=> $vbulletin->GPC['perpage']
	));

	if (count($logs))
	{
		if ($vbulletin->GPC['pagenumber'] != 1)
		{
			$prv = $vbulletin->GPC['pagenumber'] - 1;
			$firstpage = "<input type=\"button\" class=\"button\" value=\"&laquo; " . $vbphrase['first_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=changelog&action=view&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=1&startdate=" . $vbulletin->GPC['startdate'] . "&enddate=" . $vbulletin->GPC['enddate'] . "&userid=" . $vbulletin->GPC['userid'] . "&_fields=" . urlencode($vbulletin->GPC['fields']) . "'\">";
			$prevpage = "<input type=\"button\" class=\"button\" value=\"&lt; " . $vbphrase['prev_page'] . "\" tabindex=\"1\" onclick=\"window.location='vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=changelog&action=view&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$prv&startdate=" . $vbulletin->GPC['startdate'] . "&enddate=" . $vbulletin->GPC['enddate'] . "&userid=" . $vbulletin->GPC['userid'] . "&_fields=" . urlencode($vbulletin->GPC['fields']) . "'\">";
		}

		if ($vbulletin->GPC['pagenumber'] != $totalpages)
		{
			$nxt = $vbulletin->GPC['pagenumber'] + 1;
			$nextpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['next_page'] . " &gt;\" tabindex=\"1\" onclick=\"window.location='vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=changelog&action=view&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$nxt&startdate=" . $vbulletin->GPC['startdate'] . "&enddate=" . $vbulletin->GPC['enddate'] . "&userid=" . $vbulletin->GPC['userid'] . "&_fields=" . urlencode($vbulletin->GPC['fields']) . "'\">";
			$lastpage = "<input type=\"button\" class=\"button\" value=\"" . $vbphrase['last_page'] . " &raquo;\" tabindex=\"1\" onclick=\"window.location='vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=changelog&action=view&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=$totalpages&startdate=" . $vbulletin->GPC['startdate'] . "&enddate=" . $vbulletin->GPC['enddate'] . "&userid=" . $vbulletin->GPC['userid'] . "&_fields=" . urlencode($vbulletin->GPC['fields']) . "'\">";
		}

		$headings = array();
		$headings[] = $vbphrase['date'];
		$headings[] = $vbphrase['user_name'];
		$headings[] = $vbphrase['dbtech_vbsecurity_watcher'];
		$headings[] = $vbphrase['action'];
		$headings[] = $vbphrase['dbtech_vbsecurity_change'];
		$headings[] = $vbphrase['ip_address'];

		print_form_header('', '');
		print_description_row(construct_link_code($vbphrase['restart'], "vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=changelog"), false, count($headings), 'thead', 'right');
		print_table_header(construct_phrase($vbphrase['dbtech_vbsecurity_changelog_list_page_x_y_there_are_z_total_log_entries'], vb_number_format($vbulletin->GPC['pagenumber']), vb_number_format($totalpages), vb_number_format($counter)), count($headings));
		print_cells_row($headings, 1);

		foreach ($logs as $log)
		{
			// Ensure this is correct
			$log['username'] = ($log['username'] ? $log['username'] : 'user id: ' . $user['userid']);

			$cell = array();
			$cell[] = '<span class="smallfont">' . vbdate($vbulletin->options['logdateformat'], $log['dateline']) . '</span>';
			$cell[] = "<a href=\"vbsecurity.php?" . $vbulletin->session->vars['sessionurl'] . "do=changelog&action=view&pp=" . $vbulletin->GPC['perpage'] . "&orderby=" . $vbulletin->GPC['orderby'] . "&page=1&startdate=" . $vbulletin->GPC['startdate'] . "&enddate=" . $vbulletin->GPC['enddate'] . "&userid=" . $log['userid'] . "&_fields=" . urlencode($vbulletin->GPC['fields']) . "\">$log[username]</a>";
			$cell[] = $vbphrase['dbtech_vbsecurity_watchers_' . $log['script']];
			$cell[] = $vbphrase['dbtech_vbsecurity_' . $log['action']];
			$cell[] = ($vbphrase['dbtech_vbsecurity_watcher_' . $log['field']] ? $vbphrase['dbtech_vbsecurity_watcher_' . $log['field']] : 'dbtech_vbsecurity_watcher_' . $log['field']) . ': ' . $log['change'];
			$cell[] = "<a href=\"usertools.php?" . $vbulletin->session->vars['sessionurl'] . "do=doips&depth=2&ipaddress=$log[ipaddress]&hash=" . CP_SESSIONHASH . "\">$log[ipaddress]</a>";

			//print_cells_row($cell, 0, 0, -4);
			print_cells_row($cell, false, false, 0, 'top', false, true);
		}

		print_table_footer(count($headings), "$firstpage $prevpage &nbsp; $nextpage $lastpage");
	}
	else
	{
		print_stop_message('no_results_matched_your_query');
	}
}

// ###################### Start prune log #######################
if ($_REQUEST['action'] == 'prune' AND can_access_logs($vbulletin->config['SpecialUsers']['canpruneadminlog'], '<p>' . $vbphrase['dbtech_vbsecurity_log_pruning_restricted'] . '</p>'))
{
	$vbulletin->input->clean_array_gpc('r', array(
		'userid'	=> TYPE_INT,
		'daysprune'	=> TYPE_INT
	));

	$datecut = TIMENOW - (86400 * $vbulletin->GPC['daysprune']);
	$query = "SELECT COUNT(*) AS total FROM " . TABLE_PREFIX . "dbtech_vbsecurity_changelog WHERE dateline < $datecut";

	if ($vbulletin->GPC['userid'])
	{
		$query .= "\nAND userid = " . $vbulletin->GPC['userid'];
	}

	$logs = $db->query_first_slave($query);
	if ($logs['total'])
	{
		print_form_header('vbsecurity', 'changelog');
		construct_hidden_code('action', 'do_prune');
		construct_hidden_code('datecut', $datecut);
		construct_hidden_code('userid', $vbulletin->GPC['userid']);
		print_table_header($vbphrase['dbtech_vbsecurity_prune_log_entries']);
		print_description_row(construct_phrase($vbphrase['dbtech_vbsecurity_prune_log_entries_verify'], vb_number_format($logs['total'])));
		print_submit_row($vbphrase['yes'], 0, 0, $vbphrase['no']);
	}
	else
	{
		print_stop_message('no_results_matched_your_query');
	}

}

// ###################### Start do prune log #######################
if ($_POST['action'] == 'do_prune' AND can_access_logs($vbulletin->config['SpecialUsers']['canpruneadminlog'], '<p>' . $vbphrase['dbtech_vbsecurity_log_pruning_restricted'] . '</p>'))
{
	$vbulletin->input->clean_array_gpc('p', array(
		'userid'	=> TYPE_INT,
		'datecut'	=> TYPE_INT
	));

	$query = "DELETE FROM " . TABLE_PREFIX . "dbtech_vbsecurity_changelog WHERE dateline < " . $vbulletin->GPC['datecut'];

	if ($vbulletin->GPC['userid'])
	{
		$query .= "\nAND userid = " .  $vbulletin->GPC['userid'];
	}

	$db->query_write($query);

	define('CP_REDIRECT', 'vbsecurity.php?do=changelog');
	print_stop_message('dbtech_vbsecurity_log_pruned_successfully');
}

print_cp_footer();
?>